#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009-2010 Yukikaze
#import sys # モジュール属性 argv を取得するため
import os
import re
import time

import chdb
import configreader
import tv2ts
import recdblist

def write(pout, ch):
    """
    tsを取得してepgの入ったxmlとして書き出す
    """
    timet = "90"
    if re.search(u'CS', ch):
        timet = "180"
    elif len(ch)>2:
        timet = "240"
    write_time(pout, ch ,timet)
def write_time(pout, ch ,times):
    """
    指定された時間分tsを取得してepgの入ったxmlとして書き出す
    """
    recdblist.Commonlogex(u"通常","write_time(ts2epg.py)",u"Ts-EPG XML書き出し処理開始" ,u"CH:"+ch)
    timet = times
    if re.search(u'CS', ch):
        mode = "/CS"
    elif len(ch)>2:
        mode = "/BS"
    else:
        mode = chdb.bctypesearch(u'te' + ch)['ontv']
    epgdump = configreader.getpath("epgdump")
    if os.access(pout + ".ts", os.F_OK):
        os.remove(pout + ".ts")
    time.sleep(10)
    tv2ts.tv2tsmix(pout + ".ts", ch, timet)
    exe = "export LANG=ja_JP.UTF-8 && nice -n 15 " + epgdump + " " + mode + " " + pout + ".ts " + pout
    recdblist.printutf8(exe)
    recdblist.Commonlogex(u"通常", "write_time(ts2epg.py)", exe,"")
    os.system(exe)
    time.sleep(10)

